%% Function for plotting 2D graphs
% Function that plots basic but good-looking 2D graphs.

function TwoDimPlot(x_var,y_var,x_tick,x_tick_label,y_tick,y_tick_label,x_lim,y_lim,title_label,x_label,y_label,leg_label,leg_title)
figure; hold on;
grid on; grid minor; box on;
set(findobj(gca,'Type','text'),'fontsize',16,'fontweight','n','fontname','Times')
set(gcf,'color','w');
plot(x_var,y_var,'LineWidth',2);
set(gca,'XTick',x_tick,'XTicklabel',x_tick_label,'fontweight','n','fontsize',16,'fontname','Times');
set(gca,'Ytick',y_tick,'YTicklabel',y_tick_label,'fontweight','n','fontsize',16,'fontname','Times');
title(title_label,'fontsize',23,'fontweight','n','fontname','Times');
xlabel(x_label,'fontweight','n','fontsize',19,'fontname','Times');
ylabel(y_label,'fontweight','n','fontsize',19,'fontname','Times'); 
xlim(x_lim);
ylim(y_lim);
leg = legend(leg_label);
if (leg_title ~= "")
    title(leg,leg_title);
end
end